uniform float u_exposure;
uniform float u_decay;
uniform float u_density;
uniform float u_weight;
uniform vec2 u_lightPositionOnScreen;
uniform vec2 u_uvSize;
varying vec2 v_texCoord;
//precision highp float;

const int NUM_SAMPLES = 20;

void main()
{
    
    vec2 deltaTextCoord = vec2( v_texCoord - u_lightPositionOnScreen);

    vec2 textCoo = v_texCoord - u_lightPositionOnScreen;
    textCoo = textCoo * 1.0;
    textCoo = textCoo + u_lightPositionOnScreen;

    
    
    vec4 finalColor = vec4(texture2D(CC_Texture1, textCoo * u_uvSize ).rgb, 1.0);
    vec4 sampl;
    
    deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * u_density;
    float illuminationDecay = 1.0;
  
    for(int i=0; i < NUM_SAMPLES ; i++)
    {

        sampl = vec4(texture2D(CC_Texture1, textCoo * u_uvSize ).rgb, 1.0);
        textCoo -= deltaTextCoord;
        sampl *= illuminationDecay * u_weight;
        
        finalColor += sampl;
        illuminationDecay *= u_decay;
    }
    
    gl_FragColor = finalColor *  u_exposure;
}
